﻿using System;
using System.IO;
using System.Net;
using System.Text;

namespace VIRP.EFR.BLL
{
    internal static class HttpWebRequestExtensions
    {
        public static string TryGetResponse(
            this WebRequest request,
            string userId,
            byte[] data = null)
        {
            Uri uri = request.RequestUri;
            string requestUri = uri != null && !string.IsNullOrEmpty(uri.ToString()) ? uri.ToString() : "Not set.";
            string requestMethod = request != null && !string.IsNullOrEmpty(request.Method) ? request.Method : "Not set.";

            try
            {
                using (var response = request.GetResponse() as HttpWebResponse)
                {
                    if (response == null)
                        throw new WebException(requestUri + ": Response is null");

                    if (response.StatusCode != HttpStatusCode.OK)
                        throw new WebException(requestUri + ": request failed");

                    var responseStream = response.GetResponseStream();
                    if (responseStream == null)
                        throw new WebException(requestUri + ": ResponseStream is null");

                    using (var reader = new StreamReader(responseStream))
                    {
                        if (reader != null)
                            return reader.ReadToEnd();
                    }
                }

                return null;
            }
            catch (WebException ex)
            {
                var requestData = data != null ? Encoding.UTF8.GetString(data) : "Not set.";
                var comments = "Request Method: " + requestMethod + ", Request Url: " + requestUri + ", Request Data: " + requestData;
                var message = "No response data available (possible timeout).";

                WebResponse webResponse = ex.Response;
                if (webResponse != null)
                {
                    using (Stream responseStream = webResponse.GetResponseStream())
                    {
                        if (responseStream != null)
                        {
                            using (var reader = new StreamReader(responseStream))
                            {
                                if (reader != null)
                                    message = reader.ReadToEnd();
                            }
                        }
                    }
                }

                message = string.Format("Error completing request: {0}, exception: {1}", message, ex.Message);
                LogManager.LogError(message, string.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), string.Empty, 0);
                throw ex;
            }
        }
    }
}